package nemosofts.voxradio.executor;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.interfaces.EpisodeListener;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.AsyncTaskExecutor;
import okhttp3.RequestBody;

public class LoadEpisode extends AsyncTaskExecutor<String, String, String> {

    private final EpisodeListener episodeListener;
    private final ArrayList<ItemRadio> arrayList = new ArrayList<>();
    private final RequestBody requestBody;
    private String verifyStatus = "0";
    private String message = "";

    public LoadEpisode(EpisodeListener episodeListener, RequestBody requestBody) {
        this.episodeListener = episodeListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        episodeListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected  String doInBackground(String strings)  {
        String json = ApplicationUtil.responsePost(Callback.API_URL, requestBody);
        try {
            JSONObject jOb = new JSONObject(json);
            JSONArray jsonArray = jOb.getJSONArray(Callback.TAG_ROOT);

            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject objJson = jsonArray.getJSONObject(i);

                if (!objJson.has(Callback.TAG_SUCCESS)) {

                    String id = objJson.getString("id");
                    String podcastID = objJson.getString("podcast_id");
                    String episodeTitle = objJson.getString("episode_title");
                    String episodeUrl = objJson.getString("episode_url");
                    String podcastName = objJson.getString("podcast_name");
                    String image = objJson.getString("podcast_image").replace(" ", "%20");
                    if (image.isEmpty()) {
                        image = "null";
                    }

                    ItemRadio objItem = new ItemRadio(id, podcastID, episodeTitle, episodeUrl, image,
                            "0","0","0", podcastName,false,false);
                    arrayList.add(objItem);

                } else {
                    verifyStatus = objJson.getString(Callback.TAG_SUCCESS);
                    message = objJson.getString(Callback.TAG_MSG);
                }
            }
            return "1";
        } catch (Exception e) {
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        episodeListener.onEnd(s, verifyStatus, message, arrayList);
    }
}

